![[Pasted image 20250725192607.png]]

## Importance of Network Telemetry

- **Network Visibility and Awareness**
    - Essential for ensuring network availability.
    - Provides insight into real-time network activity.
- **Detection Capabilities**
    - Telemetry enables detection of unusual or malicious behavior.
    - Works with dedicated analysis systems to monitor and correlate network activities.

---

## Responding to Potential Network Compromises

- **Signs of Compromise**
    - Data exfiltration by network devices.
    - Unexpected packet forwarding.
    - Unrequested ICMP replies.
    - Other unusual device behaviors.
- **Administrator Responsibilities**
    - Verify network device integrity.
    - Detect and assess indicators of compromise.

---

## Analyzing Telemetry Data

- **Critical Nature of Analysis**
    - Telemetry indicators must be found and evaluated.
    - Anomaly detection is challenging without a baseline.
- **Establishing a Network Traffic Baseline**
    - Provides a reference point for normal network activity.
    - Helps identify deviations and potential threats.

---

## Steps to Protect and Monitor Infrastructure Devices

1. **Harden Devices**
    - Strengthen security configurations.
2. **Instrument the Network**
    - Deploy tools and systems to collect telemetry.
3. **Establish a Baseline**
    - Document standard network traffic patterns.
4. **Analyze Deviations**
    - Monitor for abnormal behaviors and investigate.

---

## Recommended Baseline Telemetry for Network Devices

- Time synchronization
- Local device traffic statistics
- System status information
- Syslog
- Simple Network Management Protocol (SNMP)
- Access Control List (ACL) logging
- Accounting
- Archive configuration change logger
- Packet capture

---

## Key Components of Network Telemetry

### 1. NetFlow and IPFIX

- **NetFlow**
    - Supported on many Cisco devices and firewalls.
    - Generates records about network traffic and characteristics.
    - Reports details such as source/destination IP, port numbers, and TCP headers.
    - Data is exported to a collector for analysis (e.g., Cisco Secure Network Analytics).
    - Enables advanced threat detection and response.
- **IPFIX**
    - Open IETF standard, evolves NetFlow to allow broader data export.
    - Vendors can export any performance details as needed.
    - Defined in RFCs 5101 and 5102.

### 2. Packet Captures

- **Deep Packet Inspection**
    - Network taps/captures provide forensic data.
    - Useful for investigating end-host compromises.
    - Careful analysis is required to identify non-traditional indicators of compromise.

### 3. Syslog and SNMP Traps

- **Log Monitoring**
    - Device logs can reveal suspicious activities (e.g., brute-force attacks on credentials).
    - Log collectors can correlate events to identify compromises.

---

## Security Information and Event Management (SIEM)

- **Role of SIEM Servers**
    - Centralize collection of telemetry data.
- **Key Features**
    - **Data Normalization:** Standardizes data from various sources for comparison.
    - **Data Correlation:** Combines multiple logs/events to clarify network activities and identify incidents.

---

### Notes

- Baseline telemetry is cost-effective and relatively easy to implement.
- Correlating multiple data sources provides stronger insight than individual logs alone.